package com.bxm.localnews.integration;

import com.bxm.egg.user.facade.bo.UserInfoBO;
import com.bxm.egg.user.facade.bo.UserStatisticsBO;
import com.bxm.egg.user.facade.service.UserInfoFacadeService;
import com.bxm.localnews.converter.IntegrationConverter;
import com.bxm.localnews.dto.UserRegisterInfoDTO;
import com.bxm.localnews.news.vo.UserBean;
import com.bxm.localnews.vo.VirtualUserInfo;
import com.bxm.newidea.component.sync.core.CacheHolder;
import com.bxm.newidea.component.sync.core.SyncCacheHolderFactory;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

import static com.bxm.localnews.news.constant.MemoryCacheKey.USER_LOCAL_CACHE;
import static com.bxm.localnews.news.constant.MemoryCacheKey.USER_VIRTUAL_TYPE_CACHE;

@Slf4j
@Service
public class UserIntegrationService {

    @Resource
    private CacheHolder cacheHolder;

    private final UserInfoFacadeService userInfoFacadeService;

    public UserIntegrationService(InnerServiceIntegrationService innerServiceIntegrationService) {
        userInfoFacadeService = innerServiceIntegrationService.getUserInfoFacadeService();
    }

    private Map<Long, Byte> virtualUserTypeMap = Maps.newConcurrentMap();

    @PostConstruct
    public void initCache() {
        SyncCacheHolderFactory.builder()
                .keyGenerator(USER_LOCAL_CACHE)
                .maximumSize(20000)
                .timeUnit(TimeUnit.MINUTES)
                .duration(1)
                .cacheLoader(this::loadUser)
                .build();

        SyncCacheHolderFactory.builder()
                .keyGenerator(USER_VIRTUAL_TYPE_CACHE)
                .maximumSize(20000)
                .timeUnit(TimeUnit.MINUTES)
                .duration(5)
                .cacheLoader(this::loadVirtualUserType)
                .build();
    }

    private Byte loadVirtualUserType(Long userId) {
        //使用本地缓存
        Byte virtualUserType = virtualUserTypeMap.get(userId);

        //本地缓存不存在时通过服务获取远程数据
        if (null == virtualUserType) {
            virtualUserType = 0;
            virtualUserTypeMap.put(userId, virtualUserType);
        }

        return virtualUserType;
    }

    private UserBean loadUser(Long userId) {
        UserInfoBO userInfoBO = userInfoFacadeService.selectUserFromCache(userId);

        return IntegrationConverter.INSTANCE.of(userInfoBO);
    }

    public UserBean selectUserFromCache(Long userId) {
        if (null != userId) {
            return cacheHolder.get(USER_LOCAL_CACHE, userId);
        }

        UserBean user = new UserBean();
        user.setId(userId);
        return user;
    }

    public UserStatisticsBO getUserStatisticsInfo(Long userId) {
        return userInfoFacadeService.getUserStatisticsInfo(userId);
    }

    public List<UserBean> batchUserInfo(List<Long> userIdList) {
        List<UserInfoBO> userInfoBOList = userInfoFacadeService.selectUserListFromCache(userIdList);

        return IntegrationConverter.INSTANCE.of(userInfoBOList);
    }

    public Boolean addPostReplyNum(Long userId, Integer type) {
        return false;
    }

    public List<VirtualUserInfo> getVirtualUserList(Integer num) {
        return Lists.newArrayList();
    }

    public List<VirtualUserInfo> getVirtualUserListNew(Integer num, List<Integer> types, String areaCode) {
        return null;
    }

    @Async
    public void updateUserLikeNumByUserId(Long userId) {
    }

    public Byte getVirtualUserType(Long userId) {
        if (null == userId) {
            return 0;
        }

        return cacheHolder.get(USER_VIRTUAL_TYPE_CACHE, userId);
    }

    /**
     * 获取用户的注册信息 注册时间、首次登录时间等等
     *
     * @param userId userId
     * @return 用户的注册信息
     */
    public UserRegisterInfoDTO userRegisterInfo(Long userId) {

        return null;
    }
}
