package com.bxm.egg.user.facade.param;

import com.bxm.egg.user.enums.OperateTypeEnum;
import com.bxm.egg.user.enums.UserStatisticsTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

import java.io.Serializable;

/**
 * 操作用户统计数据入参
 *
 * @author wzy
 * @version 1.0
 * @date 2021/9/28 6:47 下午
 */
@ApiModel("用户统计值操作入参")
@Builder
@AllArgsConstructor
@Data
public class UserStatisticsOperateParam implements Serializable {
    private static final long serialVersionUID = -8789923131802603702L;

    @Tolerate
    public UserStatisticsOperateParam() {

    }

    @ApiModelProperty("用户id")
    private Long userId;

    @ApiModelProperty("用户统计值类型")
    private UserStatisticsTypeEnum userStatisticsType;

    @ApiModelProperty("操作类型")
    private OperateTypeEnum operateTypeEnum;

    @ApiModelProperty("操作值")
    private Integer operateNum;
}