package com.bxm.egg.user.model.bo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

import java.io.Serializable;

/**
 * @author wzy
 * @version 1.0
 * @date 2021/10/18 4:26 下午
 */
@Data
@ApiModel("用户微信绑定BO")
@AllArgsConstructor
@Builder
public class UserWechatBindBO implements Serializable {

    @Tolerate
    public UserWechatBindBO() {

    }

    private static final long serialVersionUID = -7301898597084535256L;
    @ApiModelProperty(value = "微信的openId", required = true)
    private String openId;

    @ApiModelProperty(value = "微信的unionId", required = true)
    private String unionId;

    @ApiModelProperty(value = "微信昵称", required = true)
    private String nickName;

    @ApiModelProperty(value = "微信头像地址")
    private String headImageUrl;

    @ApiModelProperty(value = "获取的性别信息，1：男性，2：女性")
    private Integer sex;

    @ApiModelProperty(value = "国家，如中国为 CN")
    private String country;

    @ApiModelProperty(value = "普通用户个人资料填写的城市")
    private String city;

    @ApiModelProperty(value = "普通用户个人资料填写的省份")
    private String province;

    @ApiModelProperty("用户id")
    private Long userId;
}