package com.bxm.egg.user.model.dto;

import com.bxm.egg.user.model.UserEquityDTO;
import com.bxm.egg.user.model.dto.medal.MedalMainPageSimpleDTO;
import com.bxm.newidea.component.tools.DateUtils;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDate;
import java.util.List;

@ApiModel(description = "个人主页相关信息返回实体")
@Data
public class BaseHomePage {

    @ApiModelProperty(value = "用户id")
    private Long id;

    @ApiModelProperty(value = "头像链接")
    private String headImg;

    @ApiModelProperty(value = "昵称")
    private String nickname;

    @ApiModelProperty(value = "个人简介")
    private String personalProfile;

    @ApiModelProperty(value = "年龄")
    private Integer age;

    @ApiModelProperty(value = "星座")
    private String constellation;

    @ApiModelProperty(value = "关注数量")
    private Integer attentionNum;

    @ApiModelProperty(value = "粉丝数量")
    private Integer fanNum;

    @ApiModelProperty(value = "点赞数量")
    private Integer likeNum;

    @ApiModelProperty(value = "背景图")
    private String backgroundImgUrl;

    @ApiModelProperty("性别 0:未知; 1:男; 2:女")
    private Byte sex;

    @ApiModelProperty("分享链接")
    private String shareUrl;

    @ApiModelProperty("分享标题")
    private String shareTitle;

    @ApiModelProperty("分享副标题")
    private String shareSubTitle;

    @ApiModelProperty("行业标签")
    private String industry;

    @ApiModelProperty("兴趣爱好标签列表")
    private List<String> userTagList;

    @ApiModelProperty("年龄段 如：90后")
    private String generation;

    @ApiModelProperty("生日")
    @JsonFormat(pattern = DateUtils.DATE_FORMAT_MONTH_DAY_FORMAT)
    private LocalDate birthday;

    @ApiModelProperty("家乡")
    private String hometownName;

    @ApiModelProperty("居住地")
    private String locationName;

    @ApiModelProperty("情感状态 0：保密  1：单身  2：恋爱中  3：已婚")
    private Byte relationshipStatus;

    @ApiModelProperty("用户类型，0：测试用户，1：真实用户，2：马甲号")
    private Integer type;

    @ApiModelProperty("3.12.0 主页勋章简易信息")
    private MedalMainPageSimpleDTO medalMainPageSimpleDTO;

    @ApiModelProperty("3.12.0 用户温暖值等级信息")
    private UserEquityDTO userWarmLevelDTO;
}
