package com.bxm.egg.user.model.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import java.time.LocalDateTime;
import java.io.Serializable;
import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 临时邀请绑定表
 * </p>
 *
 * @author liujia
 * @since 2021-11-09
 */
@Data
@EqualsAndHashCode(callSuper = false)
@TableName("t_temp_invite_bind")
@ApiModel(value="TempInviteBindEntity对象", description="临时邀请绑定表")
public class TempInviteBindEntity implements Serializable {

    private static final long serialVersionUID = 1L;

    private Long id;

    @ApiModelProperty(value = "邀请人的id")
    private Long userId;

    @ApiModelProperty(value = "被邀请人的unionid")
    private String unionId;

    @ApiModelProperty(value = "来源 1 邀请页 2 添加好友页")
    private Integer source;

    @ApiModelProperty(value = "邀请创建时间")
    private Date createTime;


}
