package com.bxm.egg.user.model.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;

/**
 * 设置为测试用户参数
 *
 * @author wzy
 * @version 1.0
 * @date 2021/10/19 10:05 上午
 */
@Data
@ApiModel(description = "设置测试用户")
public class SetTestUserParam {

    @ApiModelProperty("用户ID")
    @NotNull(message = "用户id不能为空哦~")
    private Long userId;

    @ApiModelProperty("设置或取消，1：设置为测试，0：取消测试资格")
    private Integer enable;
}