package com.bxm.egg.user.model.param.login;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;

@EqualsAndHashCode(callSuper = true)
@ApiModel(description = "创蓝闪验登录参数")
@Data
public class ChuangLanLoginParam extends LoginParam {
    private static final long serialVersionUID = 7285379702361929739L;
    @ApiModelProperty("运营商token, SDK返回  , 非空 ,（移动运营商2分钟有效期）")
    @NotBlank(message = "token不能为空")
    private String token;

    @ApiModelProperty(value = "客户端IP，可以为空，如需要使用反欺诈核验功能则可传入，由客户服务端获取的前端APP的IP", hidden = true)
    private String clientIp;

    @ApiModelProperty(value = "手机号码", hidden = true)
    private String phone;
}
