package com.bxm.egg.user.model.param.login;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * 手机号码登录
 *
 * @author wzy
 * @version 1.0
 * @date 2021/9/9 1:43 下午
 */
@Data
@ApiModel(description = "手机号码APP登录信息")
public class PhoneAppLoginParam extends LoginParam {

    private static final long serialVersionUID = 2508963771340060869L;
    @ApiModelProperty("手机号码")
    @NotBlank(message = "手机号码不能为空")
    private String phone;

    @ApiModelProperty("短信验证码")
    @NotBlank(message = "验证码不能为空")
    private String smsCode;
}