package com.bxm.egg.user.model.vo;

import com.bxm.egg.user.model.UserEquityDTO;
import com.bxm.egg.user.model.dto.ImgDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @author pf.w
 * @date 2020/12/10 15:15
 **/
@ApiModel(description = "推荐关注用户列表下行数据集合")
@Data
public class RecommendFollowUsersVo {

    @ApiModelProperty("用户ID")
    private Long userId;

    @ApiModelProperty("用户昵称")
    private String nickname;

    @ApiModelProperty("用户头像")
    private String headImg;

    @ApiModelProperty("是否关注 0：未关注 | 已关注")
    private Integer followed;

    @ApiModelProperty("用户标签")
    private List<String> userLabels;

    @ApiModelProperty("图片")
    private List<ImgDTO> imgInfo;

    @ApiModelProperty("个人介绍")
    private String desc;

    @ApiModelProperty(value = "是否是vip：0-不是 1-是", hidden = true)
    private Integer isVip;

    @ApiModelProperty(value = "星座")
    private String constellation;

    @ApiModelProperty("性别 0：未知 1：男 2：女")
    private Integer sex;

    @ApiModelProperty("年龄段 如：90后")
    private String generation;

    @ApiModelProperty("3.12.0 用户温暖值等级信息")
    private UserEquityDTO userWarmLevelDTO;
}
