package com.bxm.egg.user.param;

import lombok.Data;

@Data
public class WeightParam {

    /**
     * 年龄差值
     */
    private Integer ageMinus = 10;

    /**
     * 距离差值
     */
    private Integer distanceMinus = 2000;

    /**
     * 年龄权重
     */
    private Integer ageWeight = 8;

    /**
     * 最后登录时间权重
     */
    private Integer lastLoginTimeWeight = 8;

    /**
     * 距离权重
     */
    private Integer distanceWeight = 5;

    /**
     * 最后发帖时间权重
     */
    private Integer lastPostTimeWeight = 5;

    /**
     * 最后聊天时间权重
     */
    private Integer lastChatTimeWeight = 50;

    /**
     * 最后评论时间权重
     */
    private Integer lastCommentTimeWeight = 50;

    /**
     * 最后发小纸条时间权重
     */
    private Integer lastNoteTimeWeight = 100;

    /**
     * 性别权重
     */
    private Integer sexWeight = 5;

    /**
     * 完善资料度权重
     */
    private Integer infoWeight = 1;

    /**
     * 同城人推荐比重
     */
    private double sameCityPercent = 0.8;

}
