package com.bxm.egg.user.service.barrels.weight;

import com.bxm.egg.user.param.NativeRecommendContext;
import com.bxm.egg.user.service.barrels.BarrelSupport;
import com.bxm.egg.user.service.handler.WeightAlternateBarrelHandler;
import com.bxm.egg.user.service.handler.WeightDefaultBarrelHandler;
import com.bxm.egg.user.service.handler.WeightPreferredBarrelHandler;
import org.springframework.stereotype.Service;

@BarrelSupport(value = {
        WeightPreferredBarrelHandler.class,
        WeightDefaultBarrelHandler.class,
        WeightAlternateBarrelHandler.class})
@Service
public class WeightNearByNativeBarrel extends AbstractWeightBarrelChoose {

    @Override
    protected Boolean doInvoke(NativeRecommendContext nativeRecommendContext) {
        if (preNearbyInvoke(nativeRecommendContext)) {
            return doNearbyInvoke(nativeRecommendContext);
        }
        return false;
    }

}
