package com.bxm.egg.user.service.impl;

import com.bxm.egg.user.param.NativeRecommendContext;
import com.bxm.egg.user.service.barrels.BarrelChoose;
import com.bxm.egg.user.service.barrels.BarrelSupport;
import com.bxm.egg.user.service.intefaces.BarrelHandler;
import com.google.common.collect.Maps;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

@Service
public class BarrelInterceptorChain implements ApplicationRunner, ApplicationContextAware {

    private ApplicationContext applicationContext;

    private final Map<Class<? extends BarrelHandler>, List<BarrelChoose>> handlerMap = Maps.newHashMap();

    public void invoke(NativeRecommendContext nativeRecommendContext, BarrelHandler barrelHandler) {
        List<BarrelChoose> handlerList = getAccountFlowHandler(barrelHandler);

        for (BarrelChoose interceptor : handlerList) {
            if (interceptor.invoke(nativeRecommendContext)) {
                return ;
            }
        }
    }

    protected List<BarrelChoose> getAccountFlowHandler(BarrelHandler barrelHandler) {
        return handlerMap.get(barrelHandler.getClass());
    }

    @Override
    public void run(ApplicationArguments args) {
        Collection<BarrelChoose> filters = applicationContext.getBeansOfType(BarrelChoose.class).values();

        List<BarrelChoose> result = filters.stream()
                .sorted(Comparator.comparingInt(Ordered::getOrder))
                .collect(Collectors.toList());

        result.forEach(e->{

            BarrelSupport support = AnnotationUtils.getAnnotation(AopUtils.getTargetClass(e),
                    BarrelSupport.class);

            if (null != support) {
                for (Class<? extends BarrelHandler> barrelHandler:support.value()) {
                    if (handlerMap.containsKey(barrelHandler)) {
                        List<BarrelChoose> barrelChooseList = handlerMap.get(barrelHandler);
                        barrelChooseList.add(e);
                        handlerMap.put(barrelHandler,barrelChooseList);
                    }else{
                        List<BarrelChoose> barrelChooseList = new ArrayList<>();
                        barrelChooseList.add(e);
                        handlerMap.put(barrelHandler,barrelChooseList);
                    }
                }
            }

        });
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

}
