package com.bxm.egg.user.param;


import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.Date;

@Data
@Builder
/**
 * 客户端直接传过来的参数实体不能直接用于查数据库
 * 比如年龄的字段需要转化为出生日期
 */
public class RecommendNativeParam implements Serializable {

    @ApiModelProperty("用户id")
    private Long userId;

    @ApiModelProperty("纬度")
    private String lat;

    @ApiModelProperty("经度")
    private String lon;

    @ApiModelProperty("家乡地区编码")
    private String hometownCode;

    @ApiModelProperty("当前定位城市地区编码")
    private String currentAreaCode;

    @ApiModelProperty("当前地区编码")
    private String locationCode;

    @ApiModelProperty("用户自身的性别")
    private Byte ownSex;

    @ApiModelProperty("用户出生年月")
    private Date birth;

    @ApiModelProperty("推荐类型， NORMAL：普通的本地人推荐  FILTER：筛选推荐 OTHER：其他推荐   备注：" +
            "NORMAL：平常在xx人栏目得到的列表 下拉、上划都传NORMAL" +
            "FILTER：点筛选之后得到的列表，（注意）有数据的情况：下拉、上划都传FILTER" +
            "OTHER：如果点筛选之后，没有命中数据，则会出现<其他推荐>栏目，这时候（注意） 下拉则传FILTER，上划则传OTHER ")
    private String recommendCategory;

    @ApiModelProperty("筛选（可选）->性别")
    private Byte sex;

    @ApiModelProperty("筛选（可选）->最小年龄")
    private LocalDate startBirth;

    @ApiModelProperty("筛选（可选）->最大年龄")
    private LocalDate endBirth;

    @ApiModelProperty("筛选（可选）->年龄最大差值")
    private Integer biggestMinusBirth;

    @ApiModelProperty("筛选（可选）->所属行业")
    private Long jobCategory;

    @ApiModelProperty("查询参数")
    private WeightParam weightParam;

}