package com.bxm.egg.user.service.handler;

import com.alibaba.fastjson.JSONObject;
import com.bxm.egg.user.param.NativeRecommendContext;
import com.bxm.egg.user.param.WeightParam;
import com.bxm.egg.user.properties.RecommendProperties;
import com.bxm.egg.user.service.impl.BarrelInterceptorChain;
import com.bxm.newidea.component.tools.SpringContextHolder;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 备用桶
 */
@Service
@Slf4j
public class WeightAlternateBarrelHandler extends AbstractWeightBarrelHandler<NativeRecommendContext> {

    @Autowired
    private BarrelInterceptorChain barrelInterceptorChain;

    @Override
    protected List<Long> doHandle(NativeRecommendContext nativeRecommendContext) {
        log.debug("到达备用桶，使用指定参数进行推荐：[{}]",JSONObject.toJSON(nativeRecommendContext));
        String weightStr = recommendProperties.getWeight().getOrDefault(supportWeight(),null);
        nativeRecommendContext.addParam("weight",
                weightStr != null ? JSONObject.parseObject(weightStr, WeightParam.class) : new WeightParam());
        barrelInterceptorChain.invoke(nativeRecommendContext, this);
        return new ArrayList<>();
    }

    @Override
    public String supportWeight() {
        return "alternate-score";
    }
}
