package com.bxm.newidea.gaineggs.user.model.dto;

import com.bxm.newidea.component.param.BasicParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;

@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(description = "微信登录参数")
public class WechatLoginParam extends BasicParam {

    @ApiModelProperty(value = "微信的openId", required = true)
    @NotBlank(message = "openId不能为空")
    private String openId;

    @ApiModelProperty(value = "微信的unionId", required = true)
    @NotBlank(message = "unionId不能为空")
    private String unionId;

    @ApiModelProperty(value = "微信昵称", required = true)
    @NotBlank(message = "微信昵称不能为空")
    private String nickName;

    @ApiModelProperty(value = "微信头像地址")
    private String headImageUrl;

    @ApiModelProperty(value = "获取的性别信息,1：男性,2：女性")
    private Integer sex;

    @ApiModelProperty(value = "国家,如中国为 CN")
    private String country;

    @ApiModelProperty(value = "普通用户个人资料填写的城市")
    private String city;

    @ApiModelProperty(value = "普通用户个人资料填写的省份")
    private String province;

    @ApiModelProperty(value = "微信accessToken")
    private String accessToken;

    @ApiModelProperty(value = "请求IP", hidden = true)
    private String requestIp;

    @ApiModelProperty(value = "同盾科技的sdk返回值")
    private String blackBox;
}
