package com.bxm.localnews.activity.dto;

import com.bxm.newidea.component.vo.BaseBean;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * @Author: pf.w
 * @Date: 2020/5/11 20:23
 */
@Data
public class BaseMerchantDetail extends BaseBean {
    @ApiModelProperty("商户名")
    private String merchantName;

    @ApiModelProperty("商家头像")
    private String headImg;

    @ApiModelProperty("门面图片（多张使用逗号分隔）")
    private List<String> facadeUrl;

    @ApiModelProperty("商家相册")
    private List<String> imgUrls;

    @ApiModelProperty("商户展示地址")
    private String displayAddress;

    @ApiModelProperty("商家介绍，图文混排，支持富文本")
    private String description;

    @ApiModelProperty("商家客服电话")
    private String servicePhone;

    @ApiModelProperty(value = "折扣")
    private BigDecimal discount;

    @ApiModelProperty(value = "商圈")
    private String businessArea;

    @ApiModelProperty(value = "营业开始时间")
    private String businessStartTime;

    @ApiModelProperty(value = "营业结束时间")
    private String businessEndTime;

    @ApiModelProperty("商家简述")
    private String shortDesc;

    @ApiModelProperty("是否开通VIP 0：否  1：是")
    private Integer isVip;

    @ApiModelProperty("商家类型描述")
    private String merchantTypeDesc;
}
