package com.bxm.localnews.activity.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Map;

@Data
@ApiModel(description = "当前用户在排行榜中显示的相关信息")
public class CurrentUserRankDTO {

    @ApiModelProperty("用户ID")
    private Long userId;

    @ApiModelProperty("用户昵称")
    private String nickName;

    @ApiModelProperty("用户头像")
    private String headImg;

    @ApiModelProperty("用户发帖数量")
    private Integer postNum;

    @ApiModelProperty("评论互动总数")
    private Integer commentTotal;

    @ApiModelProperty("内容质量得分（发帖排行榜热度值）")
    private Integer contentQualityScore;

    @ApiModelProperty("互动质量得分（互动排行榜热度值）")
    private Integer interactQualityScore;

    @ApiModelProperty("邀请用户总数")
    private Integer inviteTotal;

    @ApiModelProperty("个人是否上榜信息")
    private Map<String,Integer> rankForUser;

    @ApiModelProperty("点赞数")
    private Integer likeNum;
}
