package com.bxm.localnews.activity.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;

/**
 * Created by Arei on 2018/10/17.
 */
@ApiModel(description = "优惠活动列表详情")
public class PrivilegeOverviewDTO extends BasePrivilegeDTO {

    @ApiModelProperty("商户名")
    private String merchantName;

    @ApiModelProperty("活动缩略图地址")
    private String thumbnailUrl;

    @ApiModelProperty("折扣")
    private String discount;

    @ApiModelProperty("活动详情地址")
    private String imgUrl;

    @JsonIgnore
    private Date startTime;

    @JsonIgnore
    private Double geoLat;

    @JsonIgnore
    private Double geoLng;

    @ApiModelProperty("是否有免费享活动")
    private boolean free;

    public boolean isFree() {
        return free;
    }

    public void setFree(boolean free) {
        this.free = free;
    }

    public String getImgUrl() {
        return imgUrl;
    }

    public void setImgUrl(String imgUrl) {
        this.imgUrl = imgUrl;
    }

    public String getMerchantName() {
        return merchantName;
    }

    public void setMerchantName(String merchantName) {
        this.merchantName = merchantName;
    }

    public String getThumbnailUrl() {
        return thumbnailUrl;
    }

    public void setThumbnailUrl(String thumbnailUrl) {
        this.thumbnailUrl = thumbnailUrl;
    }

    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Double getGeoLat() {
        return geoLat;
    }

    public void setGeoLat(Double geoLat) {
        this.geoLat = geoLat;
    }

    public Double getGeoLng() {
        return geoLng;
    }

    public void setGeoLng(Double geoLng) {
        this.geoLng = geoLng;
    }

    public String getDiscount() {
        return discount;
    }

    public void setDiscount(String discount) {
        this.discount = discount;
    }
}
