package com.bxm.localnews.activity.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * <p>
 *     领取的口令红包实体类
 * </p>
 *
 * @Author: JandMin
 * @since: 1.0.0
 * @Date: 2019/4/17
 */
@ApiModel(description = "领取的红包信息")
@Data
public class RedPacketGottenDTO implements Serializable {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty("红包获取记录id")
    private Long    rphId;
    @ApiModelProperty("发布者昵称")
    private String  userName;
    @ApiModelProperty("评分")
    private String  score;
    @ApiModelProperty("领取金额")
    private String  amount;
    @ApiModelProperty("领取红包时间")
    private String    obtainTime;
}
