package com.bxm.localnews.activity.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;
import java.util.Objects;
import java.util.Set;

@ApiModel("地区签到排行榜")
public class SignLeaderBoard {

    @ApiModelProperty("当前用户排名，若当前用户已在当前地区签到但未进入前20名，则排名显示为：<暂未上榜>")
    private Integer ranking;

    @ApiModelProperty("用户id")
    private Long userId;

    @ApiModelProperty("当前用户头像")
    private String headImg;

    @ApiModelProperty("当前用户昵称")
    private String nickname;

    @ApiModelProperty("当前用户签到天数，若当前用户未在当前地区签到，则连续签到天数显示为：<还未在广德签到>。地区名动态显示")
    private Integer count;

    @ApiModelProperty("签到排行榜，前20名")
    private Set<LeaderBoard> leaderBoardList;

    public static class LeaderBoard{

        private static final long serialVersionUID = 1L;

        @ApiModelProperty("排名")
        private Integer ranking;

        @ApiModelProperty("用户id")
        private Long userId;

        @ApiModelProperty("用户头像")
        private String headImg;

        @ApiModelProperty("昵称")
        private String nickname;

        @ApiModelProperty("签到天数")
        private Integer count;

        public Integer getRanking() {
            return ranking;
        }

        public LeaderBoard setRanking(Integer ranking) {
            this.ranking = ranking;
            return this;
        }

        public String getHeadImg() {
            return headImg;
        }

        public LeaderBoard setHeadImg(String headImg) {
            this.headImg = headImg;
            return this;
        }

        public String getNickname() {
            return nickname;
        }

        public LeaderBoard setNickname(String nickname) {
            this.nickname = nickname;
            return this;
        }

        public Integer getCount() {
            return count;
        }

        public LeaderBoard setCount(Integer count) {
            this.count = count;
            return this;
        }

        public Long getUserId() {
            return userId;
        }

        public LeaderBoard setUserId(Long userId) {
            this.userId = userId;
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || getClass() != o.getClass()) {
                return false;
            }
            LeaderBoard that = (LeaderBoard) o;
            return
                    Objects.equals(userId, that.userId);
        }

        @Override
        public int hashCode() {
            return Objects.hash(userId);
        }
    }

    public Integer getRanking() {
        return ranking;
    }

    public SignLeaderBoard setRanking(Integer ranking) {
        this.ranking = ranking;
        return this;
    }

    public String getHeadImg() {
        return headImg;
    }

    public SignLeaderBoard setHeadImg(String headImg) {
        this.headImg = headImg;
        return this;
    }

    public String getNickname() {
        return nickname;
    }

    public SignLeaderBoard setNickname(String nickname) {
        this.nickname = nickname;
        return this;
    }

    public Integer getCount() {
        return count;
    }

    public SignLeaderBoard setCount(Integer count) {
        this.count = count;
        return this;
    }

    public Set<LeaderBoard> getLeaderBoardList() {
        return leaderBoardList;
    }

    public SignLeaderBoard setLeaderBoardList(Set<LeaderBoard> leaderBoardList) {
        this.leaderBoardList = leaderBoardList;
        return this;
    }

    public Long getUserId() {
        return userId;
    }

    public SignLeaderBoard setUserId(Long userId) {
        this.userId = userId;
        return this;
    }
}
