package com.bxm.localnews.activity.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * Created by Arei on 2018/10/17.
 */
@ApiModel(description = "优惠活动中奖人信息")
public class WinnerDTO {
    @ApiModelProperty("昵称")
    private String nickname;

    @ApiModelProperty("电话")
    private String phone;

    @ApiModelProperty("头像")
    private String headImg;

    @ApiModelProperty("用户ID")
    private Long userId;

    @ApiModelProperty("兑奖码")
    private String commodityCode;

    @ApiModelProperty("是否需要弹窗（1弹/0不弹）")
    private Integer popup;

    @JsonIgnore
    private Long id;

    public Integer getPopup() {
        return popup;
    }

    public void setPopup(Integer popup) {
        this.popup = popup;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getCommodityCode() {
        return commodityCode;
    }

    public void setCommodityCode(String commodityCode) {
        this.commodityCode = commodityCode;
    }

    public String getNickname() {
        return nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public String getPhone() {
        return phone.replaceAll("(\\d{3})\\d{4}(\\d{4})", "$1****$2");
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getHeadImg() {
        return headImg;
    }

    public void setHeadImg(String headImg) {
        this.headImg = headImg;
    }
}
