package com.bxm.localnews.activity.param;

import com.bxm.localnews.activity.vo.DailyTask;
import com.bxm.localnews.common.constant.TaskEnum;
import com.bxm.newidea.component.vo.BaseBean;
import com.google.common.collect.Maps;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Tolerate;

import java.util.Map;

/**
 * 任务处理过程中的上下文信息
 * @author shentao
 */
@EqualsAndHashCode(callSuper = true)
@Data
@Builder
public class TaskContext extends BaseBean {

    private static final long serialVersionUID = -2959584845325815322L;

    private DailyTask dailyTask;

    private Long userId;

    private TaskEnum taskEnum;

    private String relationId;

    private String content;

    /**
     * 此任务是否需要推送消息
     */
    private Boolean pushMsg = false;

    /**
     * 完成任务的消息是否需要写入到消息中心
     */
    private Boolean persistenceMsg = false;

    /**
     * 此任务是否需要增加金币
     */
    private Boolean addGold = false;

    /**
     * 此任务是否需要发送用户自定义事件
     */
    private Boolean userEvent = false;

    @ApiModelProperty(value = "执行过程中的参数map ", hidden = true)
    private Map<String, Object> paramMap = Maps.newHashMap();

    /**
     * 调用过程中添加参数
     * @param key   参数的键值
     * @param value 键值对应的值
     */
    public TaskContext addParam(String key, Object value) {
        this.paramMap.put(key, value);
        return this;
    }

    /**
     * 获取消息传递的参数信息
     * @return 参数MAP
     */
    public Map<String, Object> getParamMap() {
        return this.paramMap;
    }

    /**
     * 获取消息传递的参数信息
     * @return 参数MAP
     */
    public <T> T getParam(String key) {
        return (T) this.paramMap.get(key);
    }

    @Tolerate
    public TaskContext() {

    }

}
