package com.bxm.localnews.activity.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

@ApiModel(description = "助力相关进度信息")
public class HelpIndexPageInfo implements Serializable {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("活动状态：0 正常 1 已下线 2 已结束")
    private Integer activityStatus;

    @ApiModelProperty("用户助力信息")
    private HelpRankInfo userHelpInfo;

    @ApiModelProperty("轮播信息")
    private List<HelpBaseInfo> roundList;

    @ApiModelProperty("换算比率")
    private BigDecimal helpRate;

    @ApiModelProperty("爱心节点")
    private Integer helpPoint;

    @ApiModelProperty("助力总金额")
    private String helpTotalAmount;

    @ApiModelProperty("已助力金额")
    private String helpedAmount;

    @ApiModelProperty("已助力百分比")
    private String helpPercent;

    @ApiModelProperty("已助力人数")
    private Integer helpedNum;

    @ApiModelProperty("个人榜前三")
    private List<HelpRankInfo> personalRankList;

    @ApiModelProperty("团队榜前三")
    private List<HelpRankInfo> teamRankList;

    @ApiModelProperty("已助力者头像列表")
    private List<String> helpedUserImgList;

    public Integer getActivityStatus() {
        return activityStatus;
    }

    public void setActivityStatus(Integer activityStatus) {
        this.activityStatus = activityStatus;
    }

    public HelpRankInfo getUserHelpInfo() {
        return userHelpInfo;
    }

    public void setUserHelpInfo(HelpRankInfo userHelpInfo) {
        this.userHelpInfo = userHelpInfo;
    }

    public List<HelpBaseInfo> getRoundList() {
        return roundList;
    }

    public void setRoundList(List<HelpBaseInfo> roundList) {
        this.roundList = roundList;
    }

    public BigDecimal getHelpRate() {
        return helpRate;
    }

    public void setHelpRate(BigDecimal helpRate) {
        this.helpRate = helpRate;
    }

    public Integer getHelpPoint() {
        return helpPoint;
    }

    public void setHelpPoint(Integer helpPoint) {
        this.helpPoint = helpPoint;
    }

    public String getHelpTotalAmount() {
        return helpTotalAmount;
    }

    public void setHelpTotalAmount(String helpTotalAmount) {
        this.helpTotalAmount = helpTotalAmount;
    }

    public String getHelpedAmount() {
        return helpedAmount;
    }

    public void setHelpedAmount(String helpedAmount) {
        this.helpedAmount = helpedAmount;
    }

    public String getHelpPercent() {
        return helpPercent;
    }

    public void setHelpPercent(String helpPercent) {
        this.helpPercent = helpPercent;
    }

    public Integer getHelpedNum() {
        return helpedNum;
    }

    public void setHelpedNum(Integer helpedNum) {
        this.helpedNum = helpedNum;
    }

    public List<HelpRankInfo> getPersonalRankList() {
        return personalRankList;
    }

    public void setPersonalRankList(List<HelpRankInfo> personalRankList) {
        this.personalRankList = personalRankList;
    }

    public List<HelpRankInfo> getTeamRankList() {
        return teamRankList;
    }

    public void setTeamRankList(List<HelpRankInfo> teamRankList) {
        this.teamRankList = teamRankList;
    }

    public List<String> getHelpedUserImgList() {
        return helpedUserImgList;
    }

    public void setHelpedUserImgList(List<String> helpedUserImgList) {
        this.helpedUserImgList = helpedUserImgList;
    }
}