package com.bxm.localnews.activity.vo;

import java.util.ArrayList;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * Created by Administrator on 2018/2/23.
 */
@ApiModel(description = "任务中心")
public class MissionModel {

    @ApiModelProperty("新手任务列表")
    private List<UserMissionModel> newbieTaskList = new ArrayList<>();

    @ApiModelProperty("日常任务列表")
    private List<UserMissionModel> dailyTaskList = new ArrayList<>();

    @ApiModelProperty("热度图标的地址，不知道有什么用")
    private String hotImg;

    @ApiModelProperty("已获得的金币数")
    private Integer gainGold;

    @ApiModelProperty("总共的金币数")
    private Integer totalGold;

    public Integer getGainGold() {
        return gainGold;
    }

    public void setGainGold(Integer gainGold) {
        this.gainGold = gainGold;
    }

    public Integer getTotalGold() {
        return totalGold;
    }

    public void setTotalGold(Integer totalGold) {
        this.totalGold = totalGold;
    }

    public String getHotImg() {
        return this.hotImg;
    }

    public void setHotImg(String hotImg) {
        this.hotImg = hotImg;
    }

    public List<UserMissionModel> getNewbieTaskList() {
        return this.newbieTaskList;
    }

    public void setNewbieTaskList(List<UserMissionModel> newbieTaskList) {
        this.newbieTaskList = newbieTaskList;
    }

    public List<UserMissionModel> getDailyTaskList() {
        return this.dailyTaskList;
    }

    public void setDailyTaskList(List<UserMissionModel> dailyTaskList) {
        this.dailyTaskList = dailyTaskList;
    }

    public void addNewbieTask(UserMissionModel missionModel) {
        this.newbieTaskList.add(missionModel);
    }

    public void addDailyTask(UserMissionModel missionModel) {
        this.dailyTaskList.add(missionModel);
    }

}
