package com.bxm.localnews.activity.vo;

import com.bxm.newidea.component.vo.BaseBean;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 录音评分上下文
 * @author liujia
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class RecordGradeContext extends BaseBean {

    /**
     * 原始口令文字
     */
    private String target;

    /**
     * 转换后的口令文字，去除标点符号，将阿拉伯数字转换为中文
     */
    private String converTarget;

    /**
     * 转换后的拼音口令文字，根据converTarget进行转换
     */
    private String pinyinTarget;

    /**
     * 解析结果文字
     */
    private String result;

    /**
     * 解析结果的拼音
     */
    private String pinyinResult;

    /**
     * 录音时长
     */
    private int duration;

    /**
     * 录音oss地址
     */
    private String ossUrl;

    /**
     * 评分结果综合信息对象
     */
    private GradeResultBean grade;
}
