package com.bxm.localnews.activity.vo;

import com.bxm.newidea.component.vo.BaseBean;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.File;

/**
 * 录音信息
 * @author liujia
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class RecordInfoBean extends BaseBean {

    /**
     * 录音内容(解析结果)
     */
    private String content;

    /**
     * 录音时长,如果存在客户端传值则优先采用，否则根据录音文件进行解析
     */
    private int duration;

    /**
     * 录音文件存储路径，如果录音文件类型不符合要求，会对其进行格式转换
     */
    private File sourceFile;

    /**
     * 录音文件后缀（格式）
     */
    private String convertExtend;

    /**
     * 格式转换后的录音文件
     */
    private File convertFile;

    /**
     * 语音oss地址
     */
    private String ossUrl;
}
