package com.bxm.localnews.activity.vo;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 * 红包信息表
 * </p>
 *
 * @author JandMin
 * @since 2019-04-18
 */
public class RedPacket implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    private Long id;
    /**
     * 发送红包的用户ID
     */
    private Long userId;
    /**
     * 发放红包的用户名
     */
    private String userName;
    /**
     * 用户头像地址
     */
    private String userImg;
    /**
     * 红包金额
     */
    private BigDecimal amount;
    /**
     * 剩余红包金额
     */
    private BigDecimal surplusAmount;
    /**
     * 期望发送数量
     */
    private Integer expectNum;
    /**
     * 实际发放数量
     */
    private Integer actualNum;
    /**
     * 审核状态（0:等待审核,1:审核拒绝,2：审核拒绝）
     */
    private Integer activeStatus;
    /**
     * 拒绝理由
     */
    private String comment;
    /**
     * 红包领取状态（1：可领取，0：已领完）
     */
    private Integer obtainStatus;
    /**
     * 是否在线(1：在线，0：下线)
     */
    private Integer onlineStatus;
    /**
     * 红包类型（1:红包墙，2：微信红包）
     */
    private Integer packetType;
    /**
     * 采用的绕口令ID
     */
    private Long twisterId;
    /**
     * 红包文字内容
     */
    private String content;
    /**
     * 宣传文案文字内容
     */
    private String promotionContent;
    /**
     * 宣传文案图片部分（使用Json格式数组存储）
     */
    private String promotionImg;
    /**
     * 地区code
     */
    private String areaCode;
    /**
     * 地区名称
     */
    private String areaName;
    /**
     * 支付订单编号
     */
    private String paymentNum;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 记录版本，默认从0开始，更新一次后+1
     */
    private Integer version;
    /**
     * 最后变更时间（变更内容时记录，领取时不记录）
     */
    private Date modifyTime;

    public String getPaymentNum() {
        return paymentNum;
    }

    public void setPaymentNum(String paymentNum) {
        this.paymentNum = paymentNum;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getUserImg() {
        return userImg;
    }

    public void setUserImg(String userImg) {
        this.userImg = userImg;
    }

    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public BigDecimal getSurplusAmount() {
        return surplusAmount;
    }

    public void setSurplusAmount(BigDecimal surplusAmount) {
        this.surplusAmount = surplusAmount;
    }

    public Integer getExpectNum() {
        return expectNum;
    }

    public void setExpectNum(Integer expectNum) {
        this.expectNum = expectNum;
    }

    public Integer getActualNum() {
        return actualNum;
    }

    public void setActualNum(Integer actualNum) {
        this.actualNum = actualNum;
    }

    public Integer getActiveStatus() {
        return activeStatus;
    }

    public void setActiveStatus(Integer activeStatus) {
        this.activeStatus = activeStatus;
    }

    public String getComment() {
        return comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public Integer getObtainStatus() {
        return obtainStatus;
    }

    public void setObtainStatus(Integer obtainStatus) {
        this.obtainStatus = obtainStatus;
    }

    public Integer getOnlineStatus() {
        return onlineStatus;
    }

    public void setOnlineStatus(Integer onlineStatus) {
        this.onlineStatus = onlineStatus;
    }

    public Integer getPacketType() {
        return packetType;
    }

    public void setPacketType(Integer packetType) {
        this.packetType = packetType;
    }

    public Long getTwisterId() {
        return twisterId;
    }

    public void setTwisterId(Long twisterId) {
        this.twisterId = twisterId;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getPromotionContent() {
        return promotionContent;
    }

    public void setPromotionContent(String promotionContent) {
        this.promotionContent = promotionContent;
    }

    public String getPromotionImg() {
        return promotionImg;
    }

    public void setPromotionImg(String promotionImg) {
        this.promotionImg = promotionImg;
    }

    public String getAreaCode() {
        return areaCode;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }

    public String getAreaName() {
        return areaName;
    }

    public void setAreaName(String areaName) {
        this.areaName = areaName;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Integer getVersion() {
        return version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public Date getModifyTime() {
        return modifyTime;
    }

    public void setModifyTime(Date modifyTime) {
        this.modifyTime = modifyTime;
    }

    @Override
    public String toString() {
        return "RedPacket{" +
        "id=" + id +
        ", userId=" + userId +
        ", userName=" + userName +
        ", userImg=" + userImg +
        ", amount=" + amount +
        ", surplusAmount=" + surplusAmount +
        ", expectNum=" + expectNum +
        ", actualNum=" + actualNum +
        ", activeStatus=" + activeStatus +
        ", comment=" + comment +
        ", obtainStatus=" + obtainStatus +
        ", onlineStatus=" + onlineStatus +
        ", packetType=" + packetType +
        ", twisterId=" + twisterId +
        ", content=" + content +
        ", promotionContent=" + promotionContent +
        ", promotionImg=" + promotionImg +
        ", areaCode=" + areaCode +
        ", areaName=" + areaName +
        ", createTime=" + createTime +
        ", version=" + version +
        ", modifyTime=" + modifyTime +
        "}";
    }
}
