package com.bxm.localnews.admin.controller.activity;

import com.bxm.localnews.admin.controller.CommonController;
import com.bxm.localnews.admin.dto.FolwerDTO;
import com.bxm.localnews.admin.param.FlowerParam;
import com.bxm.localnews.admin.service.activity.GiveOutFlowerService;
import com.bxm.localnews.admin.vo.GoldFlow;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.vo.PageParam;
import com.bxm.newidea.component.vo.PageWarper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@Api(tags = "1-56 [管理]红花发放", description = "红花发放管理接口")
@RestController
@RequestMapping("/api/flower")
public class GiveOutFlowerController extends CommonController {

	private final GiveOutFlowerService giveOutFlowerService;

	@Autowired
	public  GiveOutFlowerController( GiveOutFlowerService giveOutFlowerService){
		this.giveOutFlowerService = giveOutFlowerService;
	}

	@ApiOperation(value = "1-56-1 获得当前页面操作的唯一id", notes = "获得当前页面操作的唯一id")
	@GetMapping("/getUniquelyId")
	public Json<Long> getUniquelyId() {
		return  ResultUtil.genSuccessResult(giveOutFlowerService.getUniquelyId());
	}


	@ApiOperation(value = "1-56-2 发放红花接口", notes = "发放红花")
	@PostMapping("/giveOut")
	public Json<FolwerDTO> giveOutFolwer(@RequestBody FlowerParam flowerParam) {
		String template = flowerParam.getTemplate();
		if (StringUtils.isBlank(template)){
			return ResultUtil.genFailedResult("发放配置为空");
		}
		return ResultUtil.genSuccessResult(giveOutFlowerService.doSendFolwer(flowerParam,this.getLoginUser()));
	}
	@ApiOperation(value = "1-56-3 发放红花列表", notes = "红花列表")
	@GetMapping("/list")
	public Json<PageWarper<GoldFlow>> listFolwer(PageParam pageParam) {
		return ResultUtil.genSuccessResult(giveOutFlowerService.listFlower(pageParam));
	}











}
