package com.bxm.localnews.admin.controller.activity;

import com.bxm.localnews.admin.controller.CommonController;
import com.bxm.localnews.admin.param.HelpInfoQueryParam;
import com.bxm.localnews.admin.service.activity.HelpInfoService;
import com.bxm.localnews.admin.vo.HelpInfo;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;

@Api(tags = "1-55 [管理]公益活动助力相关", description = "公益活动助力相关")
@RestController
@RequestMapping("api/admin/helpInfo")
public class HelpInfoController extends CommonController {

    @Resource
    private HelpInfoService helpInfoService;

    @ApiOperation(value = "1-55-1 获取列表")
    @GetMapping("list")
    public Json<PageWarper<HelpInfo>> getList(HelpInfoQueryParam param) {
        return ResultUtil.genSuccessResult(helpInfoService.getList(param));
    }

    @ApiOperation(value = "1-55-2 获取详情")
    @GetMapping("detail")
    public Json<HelpInfo> getDetailById(Long id) {
        return ResultUtil.genSuccessResult(helpInfoService.getDetailById(id));
    }

    @ApiOperation(value = "1-55-3 新增或编辑")
    @PostMapping("saveOrUpdate")
    public Json<Message> saveOrUpdate(HelpInfo helpInfo) {
        return ResultUtil.genSuccessResult(helpInfoService.saveOrUpdate(helpInfo));
    }

}

