package com.bxm.localnews.admin.controller.activity;

import com.bxm.localnews.admin.param.VoteQueryParam;
import com.bxm.localnews.admin.service.activity.VoteService;
import com.bxm.localnews.admin.vo.VoteBean;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.vo.PageWarper;
import com.google.common.collect.ImmutableList;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;


@Api(tags = "1-57 投票插件管理")
@RestController
@RequestMapping("api/admin/activity/vote")
public class VoteController {

    private final VoteService voteService;

    @Autowired
    public VoteController(VoteService voteService) {
        this.voteService = voteService;
    }

    @ApiOperation(value = "1-57-1 根据投票插件ID获取投票详情")
    @ApiImplicitParam(name="voteId",value = "投票插件ID")
    @GetMapping("get")
    public Json<VoteBean> get(@RequestParam Long voteId){
        return Json.build(voteService.get(voteId));
    }

    @ApiOperation(value = "1-57-2 分页获取投票插件信息")
    @GetMapping("page")
    public Json<PageWarper<VoteBean>> page(VoteQueryParam param){
        return Json.build(voteService.getVoteByPage(param));
    }

    @ApiOperation(value = "1-57-3 保存投票插件信息")
    @PostMapping("save")
    public Json<Boolean> save(@RequestBody VoteBean entity){
        return Json.build(voteService.save(entity));
    }

    @ApiOperation(value = "1-57-4 移除投票插件信息")
    @ApiImplicitParam(name="voteId",value = "投票插件ID")
    @PostMapping("remove")
    public Json<Boolean> remove(@RequestParam Long voteId){
        return Json.build(voteService.remove(voteId));
    }

    @ApiOperation(value = "1-57-5 获取可用状态的投票查询",notes = "用于帖子中的投票插件列表选择")
    @GetMapping("list")
    public Json<List<VoteBean>> list(){
        return Json.build(voteService.getEnableVotes());
    }
}
