package com.bxm.localnews.admin.controller.base;

import com.bxm.localnews.admin.dto.TooltipStrategyDTO;
import com.bxm.localnews.admin.param.ToolsInfoParam;
import com.bxm.localnews.admin.param.ToolsParam;
import com.bxm.localnews.admin.service.base.AdminToolsService;
import com.bxm.localnews.admin.vo.Tools;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.PageWarper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.collections.ListUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**
 * @author zhaoyadong 2018/10/22 20:50
 * @desc
 */
@Api(tags = "1-10 [管理]工具管理", description = "工具管理的相关操作")
@RestController
@RequestMapping("api/admin/tools")
public class AdminToolsController {
    private static final String COMMA = ",";

    @Resource
    private AdminToolsService adminToolsService;

    @ApiOperation(value = "1-10-1 获取工具列表", notes = "根据输入参数获取对应的工具数据")
    @GetMapping("/list")
    public Json<PageWarper<Tools>> getToolsList(ToolsParam toolsParam) {
        return ResultUtil.genSuccessResult(this.adminToolsService.getToolsList(toolsParam));
    }

    @ApiOperation(value = "1-10-2 获取工具详情", notes = "")
    @GetMapping("/detail")
    public Json<Tools> getToolsById(Long id) {
        return ResultUtil.genSuccessResult(this.adminToolsService.getToolsById(id));
    }

    @ApiOperation(value = "1-10-3 工具批量上下架", notes = "")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "id字符串，以”,“分隔", required = true),
            @ApiImplicitParam(name = "status", value = "状态", required = true)
    })
    @PostMapping("batchUpdateStatus")
    public Json updateToolsStatusByIds(String ids, Byte status) {
        if (StringUtils.isBlank(ids)) {
            return ResultUtil.genFailedResult("工具id列表为空");
        }
        if (this.adminToolsService.updateToolsStatusById(Arrays.asList(ids.split(COMMA)), status) > 0) {
            return ResultUtil.genSuccessMsg("更新成功");
        }
        return ResultUtil.genFailedResult("更新失败");
    }

    //可复用1-10-3
    @ApiOperation(value = "1-10-4 工具上下架", notes = "")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "id", required = true),
            @ApiImplicitParam(name = "status", value = "状态", required = true)
    })
    @PostMapping("updateStatus")
    public Json updateToolsStatusById(String id, Byte status) {
        if (this.adminToolsService.updateToolsStatusById(Collections.singletonList(id), status) > 0) {
            return ResultUtil.genSuccessMsg("更新成功");
        }
        return ResultUtil.genFailedResult("更新失败");
    }

    @ApiOperation(value = "1-10-5 新增或编辑工具", notes = "")
    @PostMapping("saveOrUpdateTools")
    public Json saveOrUpdate(@RequestBody ToolsInfoParam toolsInfoParam) {
        if (this.adminToolsService.saveOrUpdate(toolsInfoParam) > 0) {
            return ResultUtil.genSuccessMsg("更新成功");
        }
        return ResultUtil.genFailedResult("更新失败");
    }

    @ApiOperation(value = "1-10-6 删除工具", notes = "")
    @PostMapping("deleteTools")
    public Json deleteTools(Long id) {
        if (this.adminToolsService.deleteTools(id) > 0) {
            return ResultUtil.genSuccessMsg("删除成功");
        }
        return ResultUtil.genFailedResult("删除失败");
    }

    @ApiOperation(value = "1-10-7 获取所有工具提示语策略", notes = "")
    @PostMapping("/tooltip")
    public Json<List<TooltipStrategyDTO>> getAllTooltipStrategy() {
        return ResultUtil.genSuccessResult(adminToolsService.getAllTooltipStrategy());
    }

}
