package com.bxm.localnews.admin.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;

@ApiModel(description = "优惠活动列表详情")
public class PrivilegeListDTO  {

    @ApiModelProperty("活动ID")
    private Long id;

    @ApiModelProperty("标题")
    private String title;

    @ApiModelProperty("原价")
    private BigDecimal originalCost;

    @ApiModelProperty("现价")
    private BigDecimal currentPrice;

    @ApiModelProperty("状态, 3-进行中,2-未开始,1-已结束,0-已取消")
    private Integer status;

    @ApiModelProperty(value = "活动商家所在街道名，不知道是干嘛的，隐藏了",hidden = true)
    @JsonIgnore
    private String townName = "";

    @ApiModelProperty("活动缩略图地址")
    private String thumbnailUrl;

    @ApiModelProperty("活动详情地址")
    private String imgUrl;

    @ApiModelProperty("用户和商家之间的距离")
    private String distance = "";

    @ApiModelProperty(value = "倒计时文案, 活动未开始时（status=2）显示该字段",hidden = true)
    @JsonIgnore
    private String countdown="";

    @ApiModelProperty("开始时间")
    private Date startTime;

    @ApiModelProperty("结束时间")
    private Date endTime;

    @ApiModelProperty("经度")
    private Double geoLat;

    @ApiModelProperty("维度")
    private Double geoLng;

    @ApiModelProperty("折扣")
    private String discount;

    @ApiModelProperty("商圈")
    private String businessArea;

    @ApiModelProperty("是否有免费享活动")
    private boolean free;

    @ApiModelProperty("免费享标题")
    private String freeTitle;

    @ApiModelProperty("免费享条件")
    private String freeDetail;

    @ApiModelProperty("距离")
    @JsonIgnore
    private Long distanceNum;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public BigDecimal getOriginalCost() {
        return originalCost;
    }

    public void setOriginalCost(BigDecimal originalCost) {
        this.originalCost = originalCost;
    }

    public BigDecimal getCurrentPrice() {
        return currentPrice;
    }

    public void setCurrentPrice(BigDecimal currentPrice) {
        this.currentPrice = currentPrice;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getTownName() {
        return townName;
    }

    public void setTownName(String townName) {
        this.townName = townName;
    }

    public String getThumbnailUrl() {
        return thumbnailUrl;
    }

    public void setThumbnailUrl(String thumbnailUrl) {
        this.thumbnailUrl = thumbnailUrl;
    }

    public String getImgUrl() {
        return imgUrl;
    }

    public void setImgUrl(String imgUrl) {
        this.imgUrl = imgUrl;
    }

    public String getDistance() {
        return distance;
    }

    public void setDistance(String distance) {
        this.distance = distance;
    }

    public String getCountdown() {
        return countdown;
    }

    public void setCountdown(String countdown) {
        this.countdown = countdown;
    }

    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Double getGeoLat() {
        return geoLat;
    }

    public void setGeoLat(Double geoLat) {
        this.geoLat = geoLat;
    }

    public Double getGeoLng() {
        return geoLng;
    }

    public void setGeoLng(Double geoLng) {
        this.geoLng = geoLng;
    }

    public String getDiscount() {
        return discount;
    }

    public void setDiscount(String discount) {
        this.discount = discount;
    }

    public String getBusinessArea() {
        return businessArea;
    }

    public void setBusinessArea(String businessArea) {
        this.businessArea = businessArea;
    }

    public boolean isFree() {
        return free;
    }

    public void setFree(boolean free) {
        this.free = free;
    }

    public String getFreeTitle() {
        return freeTitle;
    }

    public void setFreeTitle(String freeTitle) {
        this.freeTitle = freeTitle;
    }

    public String getFreeDetail() {
        return freeDetail;
    }

    public void setFreeDetail(String freeDetail) {
        this.freeDetail = freeDetail;
    }

    public Long getDistanceNum() {
        return distanceNum;
    }

    public void setDistanceNum(Long distanceNum) {
        this.distanceNum = distanceNum;
    }
}