package com.bxm.localnews.admin.param;

import com.bxm.newidea.component.tools.DateUtils;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.aop.interceptor.SimpleTraceInterceptor;

import java.util.Date;
import java.util.List;

@ApiModel(description = "新增新闻参数")
@Data
public class NewsAddParam {

    @ApiModelProperty("主键")
    private Long id;

    @ApiModelProperty("标题")
    private String title;

    @ApiModelProperty("频道id")
    private Integer kindId;

    @ApiModelProperty("作者")
    private String author;

    @ApiModelProperty("来源")
    private String source;

    @ApiModelProperty("页面展示发布时间")
    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT)
    private Date issueTime;

    @ApiModelProperty("生效时间")
    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT)
    private Date publishTime;

    @ApiModelProperty("标签数组")
    private String showLevels;

    @ApiModelProperty("内容")
    private String content;

    @ApiModelProperty("发布区域类型0全国 1地方")
    private Integer deliveryType;

    @ApiModelProperty("地区编码数组")
    private String areaCodes;

    @ApiModelProperty("封面图片")
    private String coverUrl;

    @ApiModelProperty("属性标签")
    private String label;

    @ApiModelProperty("热门过期时间")
    private Date hotExpireTime;

    @ApiModelProperty("置顶过期时间")
    private Date topExpireTime;

    @ApiModelProperty("置顶")
    private Byte top;

    @ApiModelProperty("频道置顶")
    private Byte kindTop;

    @ApiModelProperty("热门")
    private Byte hot;

    @ApiModelProperty("状态")
    private Byte status;


}
