package com.bxm.localnews.admin.vo;

import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @author zhaoyadong 2019/1/16 14:26
 * @desc
 */
@ApiModel(description = "消息推送记录")
public class AdminPushMessage {

    @ApiModelProperty(value = "id")
    private Long id;

    @ApiModelProperty(value = "推送标题")
    private String title;

    @ApiModelProperty(value = "推送内容")
    private String content;

    @ApiModelProperty(value = "涉及用户总数")
    private Integer userTotal;

    @ApiModelProperty(value = "推送区域范围，使用逗号分隔")
    private String areaScope;

    @ApiModelProperty(value = "实际推送时间")
    private Date pushTime;

    @ApiModelProperty(value = "推送状态（0:待确认、1:待推送、2：已推送）")
    private Byte status;

    @ApiModelProperty(value = "推送方式：透传、通知（根据枚举取值）")
    private String pushType;

    @ApiModelProperty(value = "推送平台，使用逗号分隔，取值详见枚举。为空表示全量推送")
    private String pushPlatform;

    @ApiModelProperty(value = "推送目标：1、用户，2：区域")
    private Byte pushTarget;

    @ApiModelProperty(value = "用户属性")
    private Byte userProperty;

    @ApiModelProperty(value = "消息有效时长（单位：小时）")
    private Integer periodTime;

    @ApiModelProperty(value = "通知是否有振动(0：否，1：是)")
    private Byte vibrate;

    @ApiModelProperty(value = "是否定时(0：否，1：是)")
    private Byte timing;

    @ApiModelProperty(value = "是否有提示音(0：否，1：是)")
    private Byte mute;

    @ApiModelProperty(value = "提示音类型（固定值，取值见枚举）")
    private String soundType;

    @ApiModelProperty(value = "是否浮动通知(0：否，1：是)")
    private Byte floatNotify;

    @ApiModelProperty(value = "展示文本")
    private String notifyText;

    @ApiModelProperty(value = "展开图片地址")
    private String notifyImgUrl;

    @ApiModelProperty(value = "展开式通知，取值：DISABLE TEXT IMAGE")
    private String unfoldType;

    @ApiModelProperty(value = "推送后的动作，1：启动应用，2：下载应用，3：打开新闻，4：打开资讯活动，5：打开指定网页")
    private Byte actionType;

    @ApiModelProperty(value = "推送需要的参数（json格式）")
    private String actionParams;

    @ApiModelProperty(value = "多个推送用户（“,”分隔）")
    private String targetUserid;

    @ApiModelProperty(value = "创建人（运营账号id）")
    private Long createUserId;

    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    @ApiModelProperty(value = "最后变更时间")
    private Date modifyTime;


    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public Integer getUserTotal() {
        return userTotal;
    }

    public void setUserTotal(Integer userTotal) {
        this.userTotal = userTotal;
    }

    public String getAreaScope() {
        return areaScope;
    }

    public void setAreaScope(String areaScope) {
        this.areaScope = areaScope;
    }

    public Date getPushTime() {
        return pushTime;
    }

    public void setPushTime(Date pushTime) {
        this.pushTime = pushTime;
    }

    public Byte getStatus() {
        return status;
    }

    public void setStatus(Byte status) {
        this.status = status;
    }

    public String getPushType() {
        return pushType;
    }

    public void setPushType(String pushType) {
        this.pushType = pushType;
    }

    public String getPushPlatform() {
        return pushPlatform;
    }

    public void setPushPlatform(String pushPlatform) {
        this.pushPlatform = pushPlatform;
    }

    public Byte getPushTarget() {
        return pushTarget;
    }

    public void setPushTarget(Byte pushTarget) {
        this.pushTarget = pushTarget;
    }

    public Byte getUserProperty() {
        return userProperty;
    }

    public void setUserProperty(Byte userProperty) {
        this.userProperty = userProperty;
    }

    public Integer getPeriodTime() {
        return periodTime;
    }

    public void setPeriodTime(Integer periodTime) {
        this.periodTime = periodTime;
    }

    public Byte getVibrate() {
        return vibrate;
    }

    public void setVibrate(Byte vibrate) {
        this.vibrate = vibrate;
    }

    public Byte getTiming() {
        return timing;
    }

    public void setTiming(Byte timing) {
        this.timing = timing;
    }

    public Byte getMute() {
        return mute;
    }

    public void setMute(Byte mute) {
        this.mute = mute;
    }

    public String getSoundType() {
        return soundType;
    }

    public void setSoundType(String soundType) {
        this.soundType = soundType;
    }

    public Byte getFloatNotify() {
        return floatNotify;
    }

    public void setFloatNotify(Byte floatNotify) {
        this.floatNotify = floatNotify;
    }

    public String getNotifyText() {
        return notifyText;
    }

    public void setNotifyText(String notifyText) {
        this.notifyText = notifyText;
    }

    public String getNotifyImgUrl() {
        return notifyImgUrl;
    }

    public void setNotifyImgUrl(String notifyImgUrl) {
        this.notifyImgUrl = notifyImgUrl;
    }


    public String getUnfoldType() {
        return unfoldType;
    }

    public void setUnfoldType(String unfoldType) {
        this.unfoldType = unfoldType;
    }

    public Byte getActionType() {
        return actionType;
    }

    public void setActionType(Byte actionType) {
        this.actionType = actionType;
    }

    public String getActionParams() {
        return actionParams;
    }

    public void setActionParams(String actionParams) {
        this.actionParams = actionParams;
    }

    public String getTargetUserid() {
        return targetUserid;
    }

    public void setTargetUserid(String targetUserid) {
        this.targetUserid = targetUserid;
    }

    public Long getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(Long createUserId) {
        this.createUserId = createUserId;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getModifyTime() {
        return modifyTime;
    }

    public void setModifyTime(Date modifyTime) {
        this.modifyTime = modifyTime;
    }
}
