package com.bxm.localnews.admin.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@ApiModel(description = "新闻监控条件包含的指标信息")
@Data
public class NewsMonitorIndexBean {

    @ApiModelProperty("监控指标ID")
    private Long id;

    @ApiModelProperty("监控ID")
    private Long monitorId;

    @ApiModelProperty(value = "触发时间", required = true)
    private String fireTime;

    @ApiModelProperty(value = "指标要求的最少新闻数量", required = true)
    private int num;

    public NewsMonitorIndexBean() {
    }

    public NewsMonitorIndexBean(String fireTime, int num) {
        this.fireTime = fireTime;
        this.num = num;
    }
}
