package com.bxm.localnews.admin.vo;

import com.bxm.newidea.component.tools.DateUtils;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;

public class NewsOverView {

    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("新闻标题")
    private String title;

    @ApiModelProperty("来源作者")
    private String author;

    @ApiModelProperty("分类id（一篇文章对应一个分类）")
    private Integer kindId;

    @ApiModelProperty("展示标签详情")
    private String showLevelDetail;

    @ApiModelProperty("发布时间")
    private Date publishTime;

    @ApiModelProperty("地址详情")
    private String areaDetail;

    @ApiModelProperty("新闻抓取时间")
    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT)
    private Date addTime;

    @ApiModelProperty("新闻发布时间")
    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT)
    private Date issueTime;

    @ApiModelProperty("状态 0:抓取中 1：可用  2：失效")
    private Byte status;

    @ApiModelProperty("新闻类型  1：文章  2：组图  3：视频")
    private Byte type;

    @ApiModelProperty("新闻详情跳转地址")
    private String linkUrl;

    @ApiModelProperty("审核状态")
    private Integer reviewStatus;

    @ApiModelProperty("是否推荐  0:否  1是")
    private Byte isRecommend;

    public Integer getReviewStatus() {
        return reviewStatus;
    }

    public void setReviewStatus(Integer reviewStatus) {
        this.reviewStatus = reviewStatus;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getAuthor() {
        return author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public Integer getKindId() {
        return kindId;
    }

    public void setKindId(Integer kindId) {
        this.kindId = kindId;
    }

    public String getShowLevelDetail() {
        return showLevelDetail;
    }

    public void setShowLevelDetail(String showLevelDetail) {
        this.showLevelDetail = showLevelDetail;
    }

    public Date getPublishTime() {
        return publishTime;
    }

    public void setPublishTime(Date publishTime) {
        this.publishTime = publishTime;
    }

    public String getAreaDetail() {
        return areaDetail;
    }

    public void setAreaDetail(String areaDetail) {
        this.areaDetail = areaDetail;
    }

    public Date getAddTime() {
        return addTime;
    }

    public void setAddTime(Date addTime) {
        this.addTime = addTime;
    }

    public Date getIssueTime() {
        return issueTime;
    }

    public void setIssueTime(Date issueTime) {
        this.issueTime = issueTime;
    }

    public Byte getStatus() {
        return status;
    }


    public void setStatus(Byte status) {
        this.status = status;
    }

    public Byte getType() {
        return type;
    }

    public void setType(Byte type) {
        this.type = type;
    }

    public String getLinkUrl() {
        return linkUrl;
    }

    public void setLinkUrl(String linkUrl) {
        this.linkUrl = linkUrl;
    }

    public Byte getIsRecommend() {
        return isRecommend;
    }

    public void setIsRecommend(Byte isRecommend) {
        this.isRecommend = isRecommend;
    }

}
