package com.bxm.localnews.admin.vo;

import com.bxm.newidea.component.vo.BaseBean;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;

@ApiModel
public class TaskBean extends BaseBean {

    //新手任务
    public static final Byte NEWBIEW_TASK = 10;

    //日常任务
    public static final Byte DAILY_TASK = 10;

    @ApiModelProperty("任务ID")
    private Long id;

    @ApiModelProperty("类型 10:新手任务 20:日常任务")
    private Byte type;

    @ApiModelProperty(hidden = true)
    private Byte state;

    @ApiModelProperty("任务名称")
    private String name;

    @ApiModelProperty("任务显示图标")
    private String headImg;

    @ApiModelProperty("热度表示,10:热度低, 20:热度高")
    private Byte hotState;

    @ApiModelProperty("动作描述")
    private String action;

    @ApiModelProperty(value = "任务等级（排序规则）", hidden = true)
    private Integer level;

    @ApiModelProperty("任务描述")
    private String prompt;

    @ApiModelProperty(value = "任务完成给与的奖励", hidden = true)
    private BigDecimal reward;

    @ApiModelProperty("钱币类型：10:金币 20:零钱")
    private Byte rewardType;

    @ApiModelProperty(hidden = true)
    private BigDecimal rewardLimit;

    @ApiModelProperty("奖励描述")
    private String remark;

    @ApiModelProperty(hidden = true)
    private Date createTime;

    @ApiModelProperty(hidden = true)
    private Date updateTime;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Byte getType() {
        return type;
    }

    public void setType(Byte type) {
        this.type = type;
    }

    public Byte getState() {
        return state;
    }

    public void setState(Byte state) {
        this.state = state;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getHeadImg() {
        return headImg;
    }

    public void setHeadImg(String headImg) {
        this.headImg = headImg;
    }

    public Byte getHotState() {
        return hotState;
    }

    public void setHotState(Byte hotState) {
        this.hotState = hotState;
    }

    public String getAction() {
        return action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public Integer getLevel() {
        return level;
    }

    public void setLevel(Integer level) {
        this.level = level;
    }

    public String getPrompt() {
        return prompt;
    }

    public void setPrompt(String prompt) {
        this.prompt = prompt;
    }

    public BigDecimal getReward() {
        return reward;
    }

    public void setReward(BigDecimal reward) {
        this.reward = reward;
    }

    public Byte getRewardType() {
        return rewardType;
    }

    public void setRewardType(Byte rewardType) {
        this.rewardType = rewardType;
    }

    public BigDecimal getRewardLimit() {
        return rewardLimit;
    }

    public void setRewardLimit(BigDecimal rewardLimit) {
        this.rewardLimit = rewardLimit;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

}
