package com.bxm.localnews.admin.config;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * 权限配置参数
 * @author liujia 2018/8/7 17:22
 */
@Component
@ConfigurationProperties(prefix = "shiro.security")
public class SecurityConfigurationProperties {

    private String allowOrigins;

    private String jwtSecret;

    private long jwtTokenExpiration;

    private long jwtTokenRenew;

    public String getAllowOrigins() {
        return allowOrigins;
    }

    public void setAllowOrigins(String allowOrigins) {
        this.allowOrigins = allowOrigins;
    }

    public String getJwtSecret() {
        return jwtSecret;
    }

    public void setJwtSecret(String jwtSecret) {
        this.jwtSecret = jwtSecret;
    }

    public long getJwtTokenExpiration() {
        return jwtTokenExpiration;
    }

    public void setJwtTokenExpiration(long jwtTokenExpiration) {
        this.jwtTokenExpiration = jwtTokenExpiration;
    }

    public long getJwtTokenRenew() {
        return jwtTokenRenew;
    }

    public void setJwtTokenRenew(long jwtTokenRenew) {
        this.jwtTokenRenew = jwtTokenRenew;
    }

}
