package com.bxm.localnews.admin.config.jwt;

import java.io.IOException;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.bxm.localnews.admin.constant.SecurityConstant;
import com.bxm.localnews.admin.service.security.JwtTokenService;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.web.authentication.WebAuthenticationDetailsSource;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;

/**
 * 每次请求解析并处理token，如果不存在则认为无权访问需要鉴权的资源
 */
@Component
public class JwtAuthenticationTokenFilter extends OncePerRequestFilter {

    @Autowired
    private UserDetailsService userDetailsService;

    @Autowired
    private JwtTokenService jwtTokenService;

    @Override
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response,
                                    FilterChain chain) throws ServletException, IOException {
        //从请求和cookie中获取token
        String authToken = request.getHeader(SecurityConstant.HEAD_KEY);
//        if (authToken == null) {
//            Cookie[] cookies = request.getCookies();
//            if (cookies != null && cookies.length > 0) {
//                for (Cookie cookie : cookies) {
//                    if (StringUtils.equals(cookie.getName(), SecurityConstant.HEAD_KEY)) {
//                        authToken = cookie.getValue();
//                        break;
//                    }
//                }
//            }
//        }

        if (StringUtils.isNotBlank(authToken)) {
            String account = jwtTokenService.getUsernameFromToken(authToken);

            //当前上下文中没有用户信息则获取后放到上下文中
            if (account != null && SecurityContextHolder.getContext().getAuthentication() == null) {
                //从缓存中加载用户信息
                UserDetails userDetails = this.userDetailsService.loadUserByUsername(account);

                //校验token是否可用
                if (jwtTokenService.validateToken(authToken, userDetails)) {
                    UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken(userDetails, null, userDetails.getAuthorities());
                    authentication.setDetails(new WebAuthenticationDetailsSource().buildDetails(request));
                    SecurityContextHolder.getContext().setAuthentication(authentication);

                    //如果token即将过期则颁发新的token设置到response中
                    String newToken = jwtTokenService.renewToken(authToken);
                    if (null != newToken) {
                        response.addHeader(SecurityConstant.RESPONSE_TOKEN_HEAD, newToken);
                        response.addHeader("Access-Control-Expose-Headers", SecurityConstant.RESPONSE_TOKEN_HEAD);
                    }
                }
            }
        }

        chain.doFilter(request, response);
    }
}
