package com.bxm.localnews.admin.handler;

import javax.servlet.http.HttpServletRequest;

import com.bxm.localnews.common.constant.RespCode;
import com.bxm.localnews.common.handler.CustomizeExceptionHandler;
import com.bxm.localnews.common.vo.Json;

import org.springframework.security.access.AccessDeniedException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

/**
 * @author zhaoyadong 2018/12/7 16:03
 * @desc
 */
@ControllerAdvice
@ResponseBody
public class CustonAccessDeniedExceptionHandler extends CustomizeExceptionHandler {

    @ExceptionHandler(AccessDeniedException.class)
    public Json handlBusinessException(AccessDeniedException e, HttpServletRequest request) {
        loginError(request);
        logger.error(e.getMessage(), e);
        return Json.build(RespCode.FORBIDDEN, e.getMessage());
    }
}
