package com.bxm.localnews.admin.service.activity;

import java.util.List;

import com.bxm.localnews.admin.dto.CodeTemplate;
import com.bxm.localnews.admin.param.PushCodeParam;
import com.bxm.newidea.component.vo.Message;

/**
 * @author zhaoyadong 2019/4/2 15:09
 * @desc
 */
public interface OfflinePushCodeService {

    /**
     * 生成线下地推码
     *
     * @param pushCodeParam
     * @return byte[] 压缩之后的byte数组
     */
    byte[] generatePushCode(PushCodeParam pushCodeParam);

    /**
     * 获取推广码模板信息
     *
     * @return
     */
    List<CodeTemplate> getCodeTemplates();

    /**
     * 绑定线下推广码
     *
     * @param userId
     * @param remark
     * @param code
     * @return
     */
    Message bindPushCode(Long userId, String remark, Long code);

    Boolean userIsExist(Long userId);
}
