package com.bxm.localnews.admin.service.activity.strategy;

import java.io.File;
import java.io.IOException;
import java.net.URL;

import com.bxm.localnews.admin.config.BizConfigProperties;
import com.bxm.localnews.admin.vo.AreaPushCode;
import com.bxm.newidea.component.CodeCreaterFactory;
import com.bxm.newidea.component.param.QrCodeParam;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.Message;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;

import static org.apache.commons.io.FileUtils.copyURLToFile;

/**
 * @author zhaoyadong 2019/4/2 17:30
 * @desc
 */

@RefreshScope
public abstract class AbstractPushCodeService extends BaseService implements PushCodeService {

    @Autowired
    private BizConfigProperties bizConfigProperties;

    @Override
    public Message execPushCode(AreaPushCode areaPushCode, String codeUrl) {
        Message message = Message.build();
        return message.addParam("file", generateQrcode(areaPushCode, codeUrl));
    }

    /**
     * 生成二维码
     *
     * @return
     */
    abstract File generateQrcode(AreaPushCode areaPushCode, String codeUrl);

    /**
     * 根据推广码id生成二维码
     *
     * @param code
     * @return
     * @throws IOException
     */
    File gen(String code, String url, int width, int height, String suffix) throws IOException {
        String rootPath = bizConfigProperties.getTempDir() + File.separator;


        //创建二维码
        File qrCodeFile = new File(rootPath + code + ".jpg");
        QrCodeParam param = new QrCodeParam();
        param.setWidth(width);
        param.setHeight(height);
        param.setImageFile(qrCodeFile);
        param.setMessage(url);
        param.setLogoPath(getIconFile().getPath());
        CodeCreaterFactory.createQrCode(param);

        //生成文件
        String finalFileName = code + "_final." + suffix;
        File finalFile = new File(rootPath + finalFileName);

        //删除文件
//        qrCodeFile.delete();

        return finalFile;
    }


    File getIconFile() {
        return getAliyunOssFile(bizConfigProperties.getAppIconUrl());
    }

    File getAliyunOssFile(String aliyunFilePath) {
        String fileName = StringUtils.substringAfterLast(aliyunFilePath, "/");

        String separator = StringUtils.EMPTY;
        if (!this.bizConfigProperties.getTempDir().endsWith("/") &&
                !this.bizConfigProperties.getTempDir().endsWith("\\")) {
            separator = File.separator;
        }

        File appFile = new File(this.bizConfigProperties.getTempDir() + separator + fileName);

        if (appFile.exists()) {
            return appFile;
        }

        File tempDirFile = new File(this.bizConfigProperties.getTempDir());
        if (!tempDirFile.exists()) {
            boolean result = tempDirFile.mkdirs();
            if (!result) {
                this.logger.error("创建[{}]目录失败，可能没有权限", this.bizConfigProperties.getTempDir());
            }
        }

        try {
            copyURLToFile(new URL(aliyunFilePath), appFile);
        } catch (IOException e) {
            this.logger.error(aliyunFilePath + "配置的下载文件路径不正确", e);
        }

        return appFile;
    }

}
