package com.bxm.localnews.admin.service.base;

import com.bxm.localnews.admin.dto.ChannelDTO;
import com.bxm.localnews.admin.dto.ChannelStatisDTO;
import com.bxm.localnews.admin.param.ChannelParam;
import com.bxm.localnews.admin.vo.Channel;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.vo.PageWarper;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * Created by Administrator on 2017/12/23.
 */

@Component
public interface AdminChannelService {

    /**
     * 查询渠道
     * @param param 渠道参数
     * @return 分页结果
     */
    PageWarper<ChannelDTO> queryChannelDTOs(ChannelParam param);

    /**
     * 添加渠道
     * @param channel
     * @return
     */
    Json insertSelective(Channel channel);

    /**
     * 更新渠道信息
     * @param channel
     * @return
     */
    Json updateBySelective(Channel channel);

    /**
     * 根据code查询渠道信息
     * @param code
     * @return 存在：1， 不存在：0
     */
    int countByCode(String code);

    /**
     * 启用或者禁用渠道
     * @param channelId
     * @param state
     * @return
     */
    Json changeState(Long channelId, String state);

    /**
     * 渠道统计
     * @param param
     * @return 分页结果
     */
    PageWarper<ChannelStatisDTO> channelStatis(ChannelParam param);

    /**
     * 渠道详情
     * @param id
     * @return
     */
    Channel selectById(Long id);

    /**
     * 查询注册渠道列表
     * @return
     */
    List<Channel> selectRegistChannelList();

    /**
     * 查询所有的渠道列表
     * @return
     */
    List<Channel> selectAll();
}
