package com.bxm.localnews.admin.service.base;

import com.bxm.localnews.admin.dto.AdvertMaterialDTO;
import com.bxm.localnews.admin.dto.AdvertPositionDTO;
import com.bxm.localnews.admin.param.AdvertMaterialParam;
import com.bxm.localnews.admin.param.AdvertPositionParam;
import com.bxm.newidea.component.vo.PageWarper;

import java.util.List;

public interface AdvertisementService {

    /**
     * 更改广告素材状态状态
     * @param id 素材id
     * @param status 状态
     * @return 更改结果
     */
    int updateMaterialStatus(Long id, Integer status);

    /**
     * 添加广告素材
     * @param advertMaterialParam 广告素材请求类
     * @return 添加结果
     */
    int addAdvertisementMaterial(AdvertMaterialParam advertMaterialParam);

    /**
     * 修改广告素材
     * @param advertMaterialParam 广告素材请求类
     * @return 修改结果
     */
    int modifyAdvertisementMaterial(AdvertMaterialParam advertMaterialParam);

    /**
     * 获取广告素材详情
     * @param id 主键id
     * @return 广告素材详情
     */
    AdvertMaterialDTO getAdvertisementMaterialInfo(Long id);

    /**
     * 删除广告素材-删除前需要查询素材是否已经被匹配,改功能前端做控制,先请求了关联关系的接口
     * @param id 主键id
     * @return 删除结果
     */
    int delAdvertisementMaterial(Long id);

    /**
     * 分页查询广告素材列表
     * @param advertMaterialParam 广告素材请求类
     * @return 查询结果
     */
    PageWarper<AdvertMaterialDTO> queryMaterialList(AdvertMaterialParam advertMaterialParam);


    /**
     * 更改广告投放状态
     * @param id 广告投放id
     * @param status 状态
     * @return 更改结果
     */
    int updatePositionStatus(Long id, Integer status);


    /**
     * 添加广告投放
     *
     * @param advertPositionParam 广告投放请求类
     * @return 添加结果
     */
    boolean addAdvertisementPosition(AdvertPositionParam advertPositionParam);

    /**
     * 编辑广告投放信息
     * @param advertPositionParam 广告投放请求类
     * @return 编辑结果
     */
    boolean editAdvertisementPosition(AdvertPositionParam advertPositionParam);

    /**
     * 根据id获取position详情
     * @param positionId 投放id
     * @return 广告投放详情
     */
    AdvertPositionDTO getAdvertPositionDetail(Long positionId);

    /**
     * 删除广告投放
     *
     * @param positionId 广告投放id
     * @return 删除结果
     */
    boolean delAdvertPosition(Long positionId, Integer positionType);

    /**
     * 分页查询广告投放列表
     * @param advertPositionParam 广告投放请求类
     * @return 查询结果
     */
    PageWarper<AdvertPositionDTO> queryPositionList(AdvertPositionParam advertPositionParam);

    /**
     * 根据素材id获取所有关联关系的广告投放id-在素材删除前调用
     * @param materialId 素材id
     * @return 查询结果
     */
    List<Long> relationListByMaterialId(Long materialId);

    /**
     * 获取所有启用的广告素材
     * @return 广告素材list
     */
    List<AdvertMaterialDTO> getAllMaterial();




}
