package com.bxm.localnews.admin.service.base;

import com.bxm.localnews.admin.dto.AreaInfoDTO;
import com.bxm.localnews.admin.dto.LocationInfoDTO;
import com.bxm.localnews.admin.param.AreaInfoParam;
import com.bxm.localnews.admin.param.AreaInfoQueryParam;
import com.bxm.localnews.admin.vo.AreaInfo;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;

/**
 * 区域信息相关接口
 */
public interface AreaInfoService {

    /**
     * 分页获取区域信息
     * @param areaInfoParam
     * @return
     */
    PageWarper<AreaInfo> queryPages(AreaInfoQueryParam areaInfoParam);

    /**
     * 新增区域信息
     * 同时更新localtion信息，如果不存在对应的location信息则创建
     * @param areaInfoParam
     * @return
     */
    Message saveAreaInfo(AreaInfoParam areaInfoParam);

    /**
     * 编辑区域信息
     * @param areaInfoParam
     * @return
     */
    int updateAreaInfo(AreaInfoParam areaInfoParam);

    /**
     * 删除区域信息
     * @param code
     * @return
     */
    int delAreaInfo(String code);

    AreaInfoDTO getAreaInfo(String code);

    /**
     * 编辑区域信息
     * @param areaInfoParam
     * @return
     */
    int updateCommunityContent(AreaInfoParam areaInfoParam);


    /**
     * 更新客服小助手
     * @param areaInfoParam
     * @return
     */
    int updateCustomerService(AreaInfoParam areaInfoParam);


    /**
     * 更新首页发帖入口
     * @param areaInfoParam
     * @return
     */
    int updateIndexPublish(AreaInfoParam areaInfoParam);


    /**
     * 获取location信息-使用首页发帖、客服助手、首页发帖
     * @param code
     * @return
     */
    LocationInfoDTO getLocationInfo(String code);



}
