package com.bxm.localnews.admin.service.base.impl;

import com.bxm.localnews.admin.constant.ApproveResultEnum;
import com.bxm.localnews.admin.constant.ApproveTypeEnum;
import com.bxm.localnews.admin.domain.ApproveHistoryMapper;
import com.bxm.localnews.admin.service.base.ApproveHistoryService;
import com.bxm.localnews.admin.service.security.BaseAdminService;
import com.bxm.localnews.admin.vo.ApproveHistoryBean;
import com.bxm.newidea.component.vo.Message;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;

@Service
public class ApproveHistoryServiceImpl extends BaseAdminService implements ApproveHistoryService {

    private ApproveHistoryMapper approveHistoryMapper;

    @Autowired
    public ApproveHistoryServiceImpl(ApproveHistoryMapper approveHistoryMapper) {
        this.approveHistoryMapper = approveHistoryMapper;
    }

    @Override
    public Message save(ApproveTypeEnum bizType, ApproveResultEnum result, Long bizId, String comment) {
        ApproveHistoryBean approveHistory = new ApproveHistoryBean();
        approveHistory.setId(nextId());
        approveHistory.setBizId(bizId);
        approveHistory.setBizType(bizType.name());
        approveHistory.setComment(comment);
        approveHistory.setResult(result.getCode());
        approveHistory.setApprover(getLoginUser().getId());
        approveHistory.setApproveTime(new Date());

        return Message.build(approveHistoryMapper.insert(approveHistory));
    }

}
