package com.bxm.localnews.admin.service.base.impl;

import com.bxm.localnews.admin.domain.QuartzLogMapper;
import com.bxm.localnews.admin.param.QuartzLogParam;
import com.bxm.localnews.admin.service.base.QuartzLogService;
import com.bxm.localnews.admin.vo.QuartzLogBean;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.vo.PageWarper;
import com.google.common.base.Preconditions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QuartzLogServiceImpl extends BaseService implements QuartzLogService {

    private QuartzLogMapper quartzLogMapper;

    @Autowired
    public QuartzLogServiceImpl(QuartzLogMapper quartzLogMapper) {
        this.quartzLogMapper = quartzLogMapper;
    }

    @Override
    public PageWarper<QuartzLogBean> queryQuartzLogs(QuartzLogParam param) {
        Preconditions.checkArgument(param != null);

        return new PageWarper<>(quartzLogMapper.queryLogByPageSize(param));
    }

}
