package com.bxm.localnews.admin.service.forum;

import com.bxm.localnews.admin.param.ForumPostParam;
import com.bxm.localnews.admin.vo.ForumPost;
import com.bxm.localnews.admin.vo.ForumPostApproveHistory;
import com.bxm.newidea.component.vo.PageWarper;

import java.util.List;

/**
 * 帖子管理服务
 */
public interface ForumPostService {

    /**
     * 查询帖子审核列表
     * @param param 参数
     * @return 分页结果
     */
    PageWarper<ForumPost> getApproveList(ForumPostParam param);

    /**
     * 获取帖子详情
     * @param id
     * @return
     */
    ForumPost selectByPrimaryKey(Long id);

    /**
     * 批量审核
     * @param ids
     * @param status
     * @param comment
     * @return 更新信息
     */
    int approve(String ids, Byte status, String comment);

    /**
     * 新增或编辑帖子
     * @param forumPost
     * @return
     */
    int saveOrUpdate(ForumPost forumPost);

    /**
     * 批量删除或恢复帖子
     * @param ids
     * @param status
     * @return
     */
    int deleteOrRecover(String ids, Byte status);

    /**
     * 获取新增帖子id
     * @return
     */
    Long getCreateId();

    /**
     * 获取帖子审核历史列表
     * @param id
     * @param action
     * @return
     */
    List<ForumPostApproveHistory> getApproveHistoryList(Long id, Integer action);
}
