package com.bxm.localnews.admin.service.forum;

import com.bxm.localnews.admin.param.ForumParam;
import com.bxm.localnews.admin.vo.Forum;
import com.bxm.newidea.component.vo.PageWarper;

import java.util.List;

/**
 * 版块管理服务
 */
public interface ForumService {

    /**
     * 查询版块
     * @param param 参数
     * @return 分页结果
     */
    PageWarper<Forum> getList(ForumParam param);

    /**
     * 获取版块详情
     * @param id
     * @return
     */
    Forum selectByPrimaryKey(Long id);

    /**
     * 版块上下架
     * @param id
     * @param status
     * @return 更新信息
     */
    int updateStatus(Long id, Byte status);

    /**
     * 新增或编辑版块
     * @param forum
     * @return
     */
    int saveOrUpdate(Forum forum);

    /**
     * 修改版块权重
     * @param id
     * @param order
     * @return
     */
    int updateOrder(Long id, Integer order);

    /**
     * 获取简单版块列表
     * @return
     */
    List<Forum> getSimpleList();
}
