package com.bxm.localnews.admin.service.forum.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.admin.domain.LocationMapper;
import com.bxm.localnews.admin.domain.UserMapper;
import com.bxm.localnews.admin.dto.PostTopicDTO;
import com.bxm.localnews.admin.param.ForumPostParam;
import com.bxm.localnews.admin.param.Keyword;
import com.bxm.localnews.admin.seq.NewsSeqComponent;
import com.bxm.localnews.admin.service.NewsSyncService;
import com.bxm.localnews.admin.service.forum.ForumPostService;
import com.bxm.localnews.admin.service.news.CommonTagService;
import com.bxm.localnews.admin.service.recommend.MixRecommendPoolService;
import com.bxm.localnews.admin.sync.enums.NewsTagTypeEnum;
import com.bxm.localnews.admin.vo.*;
import com.bxm.localnews.news.domain.ForumMapper;
import com.bxm.localnews.news.domain.ForumPostMapper;
import com.bxm.localnews.news.domain.TopicMapper;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.vo.PageWarper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Service
public class ForumPostServiceImpl implements ForumPostService {

    @Resource
    private UserMapper userMapper;

    @Resource
    private ForumMapper forumMapper;

    @Resource
    private TopicMapper topicMapper;

    @Resource
    private ForumPostMapper forumPostMapper;

    @Resource
    private LocationMapper locationMapper;

    @Resource
    private SequenceCreater sequenceCreater;

    @Resource
    private NewsSyncService newsSyncService;

    @Resource
    private CommonTagService commonTagService;

    @Resource
    private MixRecommendPoolService mixRecommendPoolService;

    @Resource
    private NewsSeqComponent newsSeqComponent;

    @Override
    public PageWarper<ForumPost> getApproveList(ForumPostParam param) {
        if (null != param.getStatus() && 0 == param.getStatus()) {
            param.setStatus(3);
        }
        PageWarper<ForumPost> forumList = new PageWarper<>(forumPostMapper.getList(param));

        if (CollectionUtils.isNotEmpty(forumList.getList())) {
            for (ForumPost forumPost : forumList.getList()) {
                Location location = locationMapper.selectByCode(forumPost.getAreaCode());
                if (null != location) {
                    forumPost.setArea(location);
                }

                forumPost.setForum(forumMapper.selectByPrimaryKey(forumPost.getForumId()));
                forumPost.setTopicList(topicMapper.getListByPostId(forumPost.getId()));
            }
        }

        return forumList;
    }

    @Override
    public ForumPost selectByPrimaryKey(Long id) {
        ForumPost forumPost = forumPostMapper.selectByPrimaryKey(id);

        if (forumPost != null) {
            Location location = locationMapper.selectByCode(forumPost.getAreaCode());
            if (null != location) {
                forumPost.setArea(location);
            }

            forumPost.setForum(forumMapper.selectByPrimaryKey(forumPost.getForumId()));
            forumPost.setTopicList(topicMapper.getListByPostId(forumPost.getId()));
        }

        return forumPost;
    }

    @Override
    public int approve(String ids, Byte status, String comment) {
        List<Long> idList = convertStringToList(ids);
        if (CollectionUtils.isEmpty(idList)) {
            return 0;
        }

        for (Long id : idList) {
            ForumPost forumPost = this.forumPostMapper.selectByPrimaryKey(id);
            if (forumPost == null) {
                return 0;
            }

            if ((byte) 0 == status) {
                //审核拒绝
                forumPost.setStatus((byte) 3);
                this.forumPostMapper.updateByPrimaryKeySelective(forumPost);
            } else {
                //审核通过
                forumPost.setStatus((byte) 1);
                this.forumPostMapper.updateByPrimaryKeySelective(forumPost);

                this.forumPostMapper.deletePostTag(forumPost.getId());
                savePostTag(forumPost);
            }

            this.forumPostMapper.addApproveHistory(sequenceCreater.nextLongId(), id, status, comment, new Date());
        }

        return 1;
    }

    @Override
    public int saveOrUpdate(ForumPost forumPost) {
        //id必传
        if (null == forumPost.getId()) {
            return 0;
        }

        User user = userMapper.selectByUserId(forumPost.getUserId());
        if (null != user) {
            forumPost.setUserImg(user.getHeadImg());
            forumPost.setUserName(user.getNickname());
        }

        //解析帖子内容
        if (StringUtils.isNotBlank(forumPost.getContent())) {
            //提取文案
            String text = forumPost.getContent().replaceAll("<.*?>", "");
            forumPost.setTextField(text);

            //提取图片
            List<PostImg> postImgList = new ArrayList<>();
            Pattern p = Pattern.compile("<(img|IMG)(.*?)(>|></img>|/>)");
            Matcher matcher = p.matcher(forumPost.getContent());
            boolean hasPic = matcher.find();
            //判断是否含有图片
            if (hasPic) {
                //如果含有图片，那么持续进行查找，直到匹配不到
                while (hasPic) {
                    String group = matcher.group(2);//获取第二个分组的内容，也就是 (.*?)匹配到的
                    Pattern srcText = Pattern.compile("(src|SRC)=(\"|\')(.*?)(\"|\')");//匹配图片的地址
                    Matcher matcher2 = srcText.matcher(group);
                    if (matcher2.find()) {
                        PostImg img = new PostImg();
                        img.setImgUrl(matcher2.group(3));
                        img.setType("IMG");
                        postImgList.add(img);
                    }
                    hasPic = matcher.find();//判断是否还有img标签
                }
            }

            forumPost.setImgList(JSON.toJSONString(postImgList));
        }

        int update;
        if (null == this.forumPostMapper.selectByPrimaryKey(forumPost.getId())) {
            update = this.forumPostMapper.insertSelective(forumPost);
        } else {
            update = this.forumPostMapper.updateByPrimaryKeySelective(forumPost);


            //更新推荐池内容
            MixedRecommendPool mixedRecommendPool = new MixedRecommendPool();
            mixedRecommendPool.setId(forumPost.getId());
            mixedRecommendPool.setTitle(forumPost.getTitle());
            mixedRecommendPool.setIssueTime(forumPost.getDisplayTime());
            if (StringUtils.isNotBlank(forumPost.getAreaCode())) {
                mixedRecommendPool.setAreaDetail(forumPost.getAreaCode());
            } else {
                mixedRecommendPool.setAreaDetail(null);
            }
            mixedRecommendPool.setOrigin("1");
            mixRecommendPoolService.updateMixRecommend(mixedRecommendPool);
        }

        if (CollectionUtils.isNotEmpty(forumPost.getTopicIdList())) {
            List<PostTopicDTO> list = new ArrayList<>();
            for (Long topicId : forumPost.getTopicIdList()) {
                PostTopicDTO postTopicDTO = new PostTopicDTO();
                postTopicDTO.setId(sequenceCreater.nextLongId());
                postTopicDTO.setPostId(forumPost.getId());
                postTopicDTO.setTopicId(topicId);
                list.add(postTopicDTO);
            }
            this.forumPostMapper.batchDeleteTopic(forumPost.getId());
            this.forumPostMapper.batchInsertTopic(list);
        }

        this.forumPostMapper.deletePostTag(forumPost.getId());
        savePostTag(forumPost);

        return update;
    }

    @Override
    public int deleteOrRecover(String ids, Byte status) {
        List<Long> idList = convertStringToList(ids);
        if (CollectionUtils.isEmpty(idList)) {
            return 0;
        }

        for (Long id : idList) {
            ForumPost forumPost = this.forumPostMapper.selectByPrimaryKey(id);
            if (forumPost == null) {
                return 0;
            }
            forumPost.setStatus(status);
            this.forumPostMapper.updateByPrimaryKeySelective(forumPost);

            this.forumPostMapper.deletePostTag(id);
            if ((byte) 1 == status) {
                savePostTag(forumPost);
            }
        }

        return 1;
    }

    @Override
    public Long getCreateId() {
        return newsSeqComponent.getPostId();
    }

    @Override
    public List<ForumPostApproveHistory> getApproveHistoryList(Long id, Integer action) {
        return forumPostMapper.getApproveHistoryList(id, action);
    }

    //获取分词标签并保存
    private void savePostTag(ForumPost forumPost) {
        try {
            PendingContent pendingContent = new PendingContent();
            pendingContent.setTitle(forumPost.getTitle());
            pendingContent.setContent(forumPost.getContent());
            ResponseEntity<List<Keyword>> responseEntity = newsSyncService.analysisContent(pendingContent);
            if (responseEntity.getStatusCode().isError()) {
                return;
            }

            List<Keyword> tagList = responseEntity.getBody();
            if (CollectionUtils.isNotEmpty(tagList)) {
                for (Keyword keyword : tagList) {
                    PostTag postTag = new PostTag();
                    postTag.setId(sequenceCreater.nextLongId());
                    postTag.setName(keyword.getName());
                    postTag.setTagType(NewsTagTypeEnum.TITLE_TAG.getCode());
                    postTag.setWeight(keyword.getTfidfvalue());
                    postTag.setPostId(forumPost.getId());
                    postTag.setTagId(commonTagService.saveAndGetTag(keyword.getName()));
                    forumPostMapper.savePostTag(postTag);
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private List<Long> convertStringToList(String s) {
        List<Long> result = new ArrayList<>();
        if (StringUtils.isNotBlank(s)) {
            try {
                String[] sa = s.split(",");
                for (String i : sa) {
                    result.add(Long.valueOf(i));
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }

        return result;
    }
}
